# Mega Man X3

## Where is the options page?

The [player options page for this game](../player-options) contains all the options you need to configure and export a 
config file.

## What does randomization do to this game?

Access to each Maverick Stage, weapons obtained from Mavericks and upgrades obtained from Dr. Light's capsules 
are randomized in the multiworld. The requirements for entering Dr. Doppler's Lab can be randomized to require different 
amount of items (Medals from Mavericks, Weapon count, Upgrade count, Heart Tank and Sub Tank count).

The game will be marked as completed when Sigma Virus is defeated.

## What Mega Man X3 items can appear in other players' worlds?
- Maverick Access Codes
- Maverick Weapons
- Armor Upgrades (Helmet/Arms/Body/Legs)
  - Includes chip upgrades
- Ride Armors
- Heart Tanks
- Sub Tanks
- 1-Ups
- HP Refill

## What is considered a location check in Mega Man X3?
- Defeating a Boss Enemy
- Using a Dr. Light Capsule
- Collecting a Ride Armor, a Heart Tank or a Sub Tank item
- Optionally, collecting a Pickup Item (1-Up/HP/Weapon) present within stages

## When the player receives an item, what happens?
A sound effect will play based on the type of item received, and the effects of the item will be immediately applied, 
such as unlocking the use of a weapon mid-stage. If the effects of the item cannot be fully applied (such as receiving 
a HP refill while at full health), the remaining are withheld until they can be applied.

## Quality of Life
The implementation features several enhancements to the original game's systems which attempt to make Mega Man X3 a 
much smoother experience.
- **Checkpoint Selector:** Allows you to travel to any previously visited checkpoint in the game by selecting a 
checkpoint at the stage select screen. Switch between different checkpoints with `L` or `R`.
- **Enhanced Helmet:** By getting the Helmet Upgrade item, the Checkpoint Selector will allow you to travel to any 
checkpoint regardless if you have visited them or not.
- **Bit/Byte Selector:** You can decide if you're going to face Bit or Byte in a level by pressing `SELECT` at the 
stage select screen.
- **Lab Stage Selector:** You can switch which Lab level you will travel to by pressing `SELECT` at the stage 
select screen.
- **Holo Map Anywhere:** The holographic map can be summoned at any time if the environment allows it by pressing 
`SELECT` during a valid stage.
- **Enhanced Holo Map:** The holographic map shows a lot of additional information to the player regarding the level's
checks.

## What is EnergyLink?
EnergyLink is an energy storage supported by certain games that is shared across all worlds in a multiworld. In Mega Man 
 X3, when enabled, deposits a certain amount of Energy to the EnergyLink pool. Only a quarter of the collected Energy is 
successfully sent to the EnergyLink pool.

Energy from the EnergyLink pool can be transmuted into HP and Weapon Energy with the same conversion rate. 
The transmutation can happen within the game itself and the client. In the client, you use `/heal <amount>` to request 
a heal by `<amount>` or use a `/refill <amount>` to request a weapon refill. In the game, you press `SELECT` on the item 
you want to request a refill of during the pause menu screen (X.Buster and Hyper C. will provide HP).

Weapon refills will be applied to either the current weapon, the current selected weapon on the pause menu or will be 
filled from top to bottom according to the pause menu's order if none of them are selected or being used.

## Boss weakness plando
You can enforce a singular weakness into a boss with this option, ignoring weaknesses generated by the world in case 
weaknesses are shuffled. The format is the following:
```yaml
boss_weakness_plando:
    Blizzard Buffalo: Lemon (Dash)
    Volt Catfish: Tornado Fang
```
This will force `Blizzard Buffalo` to receive increased damage from the basic shot performed when dashing and will force 
`Volt Catfish` to receive increased damage from Tornado Fang.

## Unique Local Commands
- `/resync` Deletes the current saved data in the server which will force every item to be given again. Only has 
effect during the title screen. Reached locations will be kept intact.
- `/heal <amount>` Only present with EnergyLink. Request a HP refill using EnergyLink's pool.
- `/refill <amount>` Only present with EnergyLink. Request a Weapon Energy refill using EnergyLink's pool.
- `/trade <amount>` Exchanges HP for Weapon Energy. The conversion rate is 1:1.
